package com.ejie.ab04b.model.comun;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.bea.core.repackaged.springframework.context.i18n.LocaleContextHolder;
import com.ejie.ab04b.constantes.Constantes;

/**
 * TramEstadoMot generated by UDA, 24-jul-2013 13:11:06.
 * 
 * @author UDA
 */

public class Elemento implements java.io.Serializable {
	private static final Logger LOGGER = LoggerFactory
			.getLogger(Elemento.class);
	private static final long serialVersionUID = 1L;
	private String clave;
	private String nombreEs;
	private String nombreEu;

	/**
	 * Method 'TramEstadoMot'.
	 */
	public Elemento() {
	}

	/**
	 * Method 'TramEstadoMot'.
	 * 
	 *  clave
	 *            String
	 *  nombreEs
	 *            String
	 *  nombreEu
	 *            String
	 *
	 * @param clave the clave
	 * @param nombreEs the nombre es
	 * @param nombreEu the nombre eu
	 */
	public Elemento(String clave, String nombreEs, String nombreEu) {
		this.clave = clave;
		this.nombreEs = nombreEs;
		this.nombreEu = nombreEu;
	}

	/**
	 * Method 'TramEstadoMot'.
	 * 
	 *  clave
	 *            String
	 *
	 * @param clave the clave
	 */
	public Elemento(String clave) {
		this.clave = clave;
	}

	/**
	 * Method 'getClave'.
	 * 
	 *  String
	 *
	 * @return the clave
	 */

	public String getClave() {
		return this.clave;
	}

	/**
	 * Method 'setClave'.
	 * 
	 *  clave
	 *            Long
	 *
	 * @param clave the new clave
	 */

	public void setClave(String clave) {
		this.clave = clave;
	}

	/**
	 * Method 'getNombreEs'.
	 * 
	 *  String
	 *
	 * @return the nombre es
	 */

	public String getNombreEs() {
		return this.nombreEs;
	}

	/**
	 * Method 'setNombreEs'.
	 * 
	 *  nombreEs
	 *            String
	 *
	 * @param nombreEs the new nombre es
	 */

	public void setNombreEs(String nombreEs) {
		this.nombreEs = nombreEs;
	}

	/**
	 * Method 'getNombreEu'.
	 * 
	 *  String
	 *
	 * @return the nombre eu
	 */

	public String getNombreEu() {
		return this.nombreEu;
	}

	/**
	 * Method 'setNombreEu'.
	 * 
	 *  nombreEu
	 *            String
	 *
	 * @param nombreEu the new nombre eu
	 */

	public void setNombreEu(String nombreEu) {
		this.nombreEu = nombreEu;
	}

	/**
	 * Method 'getNombre'.
	 * 
	 *  String
	 *
	 * @return the nombre
	 */

	public String getNombre() {

		Elemento.LOGGER
				.info("[CYNTIA] :LocaleContextHolder.getLocale().getLanguage(): "
						+ LocaleContextHolder.getLocale().getLanguage());

		if (Constantes.ES.equals(LocaleContextHolder.getLocale().getLanguage())) {
			return this.nombreEs;
		} else {
			return this.nombreEu;
		}

	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	@Override()
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ clave: ").append(this.clave).append(" ]");
		result.append(", [ nombreEs: ").append(this.nombreEs).append(" ]");
		result.append(", [ nombreEu: ").append(this.nombreEu).append(" ]");
		result.append("}");
		return result.toString();
	}

}
